// tickler.c - extracts next 100 appointments from an HP x00LX appointment 
//   database and sorts to remind of appointments 1 - 4+ weeks out
// Dennis Faucher November 4, 1997 dennis_faucher@hp.com
// With thanks to Andreas Garzotto's adbdump.c for record layout,
//   Usenet for add_day() and VinhHao Nguyen for DOW()
//
// 11/19/97 Fixed check for future appointments and Year 2000
// 11/22/97 Fixed garbage record inclusion
// To Do:
//    Add some command line options to shift the date range window.
//    Skip garbage records when reading an open file.

#include <stdio.h>
#include <fcntl.h>
#include <time.h>
#include <string.h>
#include <io.h>
#include <stdlib.h>

#define INT(p,n) (((int)p[n] & 255) + (((int)p[n + 1] &255) << 8)) //Makes an integer out of hex
#define S_APPT    128 //Appointment with a time
#define S_EVENT   32 //Appointment without a time

struct date {
   int day, month, year;
};

typedef struct date Date;

main(int argv, char *argc[])
{
int rval, fd, bytesread, dinx=0, i=0, int_year, int_mon, int_day, once=0;
void add_day(Date *, int);
char signature[4],hdr[6],data[16384], darray[150][80],compdate[13],apptdate[13];
time_t *curtime;
struct tm *timeptr;
Date today, tomorrow, week, two_week, three_week, month;
char num_lookup[100][3] = 
 {"00", "01", "02", "03", "04", "05", "06", "07", "08", "09",
 "10", "11", "12", "13", "14", "15", "16", "17", "18", "19",
 "20", "21", "22", "23", "24", "25", "26", "27", "28", "29",
 "30", "31", "32", "33", "34", "35", "36", "37", "38", "39",
 "40", "41", "42", "43", "44", "45", "46", "47", "48", "49",
 "50", "51", "52", "53", "54", "55", "56", "57", "58", "59",
 "60", "61", "62", "63", "64", "65", "66", "67", "68", "69",
 "70", "71", "72", "73", "74", "75", "76", "77", "78", "79",
 "80", "81", "82", "83", "84", "85", "86", "87", "88", "89",
 "90", "91", "92", "93", "94", "95", "96", "97", "98", "99"};  //Don't laugh, it was the easiest way
 int DOW(int, int, int);
 char weekday[3],*daynum[7] = {"Mo", "Tu", "We", "Th", "Fr", "Sa", "Su"};
 
 if (argv > 1)
 {
    fd=open(argc[1], O_RDONLY|O_BINARY);
    if (fd != -1)
    {

       if (argv == 5)
       {
          today.year=atoi(argc[2]);
          today.month=atoi(argc[3]);
          today.day=atoi(argc[4]);
       }
       else
       {
          time(&curtime);
          timeptr=localtime(&curtime);
          today.day=timeptr->tm_mday;
          today.month=timeptr->tm_mon + 1;
          today.year=timeptr->tm_year + 1900;  // 11/19/97
       }
       strcpy(weekday, daynum[DOW(today.year, today.month, today.day)]); // 12/1/97
       sprintf(darray[dinx], "%d/%c%c/%c%c %s|  -------------------------------------[Today]",today.year, num_lookup[today.month][0], num_lookup[today.month][1], num_lookup[today.day][0], num_lookup[today.day][1], weekday);
       strncat(darray[dinx], "", 0); //fill with NULLs for qsort
       dinx++;
       // 11/19/97 Fix next line
       sprintf(compdate, "%d/%c%c/%c%c",today.year, num_lookup[today.month][0], num_lookup[today.month][1], num_lookup[today.day][0], num_lookup[today.day][1]);
       
       tomorrow=today;
       add_day(&tomorrow, 1);
       strcpy(weekday, daynum[DOW(tomorrow.year, tomorrow.month, tomorrow.day)]); // 12/1/97
       sprintf(darray[dinx], "%d/%c%c/%c%c %s|  -------------------------------------[Tomorrow]",tomorrow. year, num_lookup[tomorrow.month][0], num_lookup[tomorrow.month][1], num_lookup[tomorrow.day][0], num_lookup[tomorrow.day][1], weekday);
       strncat(darray[dinx], "", 0); //fill with NULLs for qsort
       dinx++;
       
       week=today;
       add_day(&week, 7);
       strcpy(weekday, daynum[DOW(week.year, week.month, week.day)]); // 12/1/97
       sprintf(darray[dinx], "%d/%c%c/%c%c %s|  -------------------------------------[One Week Out]",week.year, num_lookup[week.month][0], num_lookup[week.month][1], num_lookup[week.day][0], num_lookup[week.day][1], weekday);
       strncat(darray[dinx], "", 0); //fill with NULLs for qsort
       dinx++;
       
       two_week=today;
       add_day(&two_week, 14);
       strcpy(weekday, daynum[DOW(two_week.year, two_week.month, two_week.day)]); // 12/1/97
       sprintf(darray[dinx], "%d/%c%c/%c%c %s|  -------------------------------------[Two Weeks Out]",two_week.year, num_lookup[two_week.month][0], num_lookup[two_week.month][1], num_lookup[two_week.day][0], num_lookup[two_week.day][1], weekday);
       strncat(darray[dinx], "", 0);  //fill with NULLs for qsort
       dinx++;
       
       three_week=today;
       add_day(&three_week, 21);
       strcpy(weekday, daynum[DOW(three_week.year, three_week.month, three_week.day)]); // 12/1/97
       sprintf(darray[dinx], "%d/%c%c/%c%c %s|  -------------------------------------[Three Weeks Out]",three_week.year, num_lookup[three_week.month][0], num_lookup[three_week.month][1], 
                              num_lookup[three_week.day][0], num_lookup[three_week.day][1], weekday);
       strncat(darray[dinx], "", 0);  //fill with NULLs for qsort
       dinx++;

       month=today;
       add_day(&month, 28);
       strcpy(weekday, daynum[DOW(month.year, month.month, month.day)]); // 12/1/97
       sprintf(darray[dinx], "%d/%c%c/%c%c %s|  -------------------------------------[4 Weeks Out]",month.year, num_lookup[month.month][0], num_lookup[month.month][1], num_lookup[month.day][0], num_lookup[month.day][1], weekday);
       strncat(darray[dinx], "", 0);  //fill with NULLs for qsort
       dinx++;

       bytesread=read(fd, signature, 4); //Read signature
       while (read(fd, hdr, 6) == 6) //While there are headers recs to read
       {
             bytesread=read(fd, data, (INT(hdr, 2) - 6)); //read record
             
             // if APPT or TO DO  and APPT or EVENT and < 100 records and >= today
             // 11/19/97 Fixed next 3 lines
             sprintf(apptdate, "%d/%s/%s", (data[15] + 1900), num_lookup[data[16] + 1], num_lookup[data[17] + 1]); 
             rval=strcmp(apptdate,compdate);
// 11/22/97 Fixed next line
             //if (((int)*hdr == 11) && (data[14] & (S_APPT|S_EVENT)) && (hdr[1]==(char)2) && (dinx < 150) && (rval >= 0))
             if (((int)*hdr == 11) && (data[14] & (S_APPT|S_EVENT)) && (hdr[1]==(char)2) && (rval >= 0))
            {
                int_year=data[15] + 1900;
                int_mon=data[16] + 1;
                int_day=data[17] + 1;
                strcpy(weekday, daynum[DOW(int_year, int_mon, int_day)]); // 12/1/97
                if (dinx < 150)
                {
                   sprintf(darray[dinx], "%d/%c%c/%c%c %s| %s", int_year, num_lookup[int_mon][0], num_lookup[int_mon][1], num_lookup[int_day][0], num_lookup[int_day][1], weekday, &data[27]); 
                   strncat(darray[dinx], "", 0); //fill with NULLs for qsort
                   dinx++;
                }
                else
                {
                   if (once==0)
                   {
                      qsort(darray, dinx, sizeof(darray[0]), strcmp);
                      once=1;
                   }
                   sprintf(darray[149], "%d/%c%c/%c%c %s| %s", int_year, num_lookup[int_mon][0], num_lookup[int_mon][1], num_lookup[int_day][0], num_lookup[int_day][1], weekday, &data[27]); 
                   strncat(darray[149], "", 0); //fill with NULLs for qsort
                   qsort(darray, dinx, sizeof(darray[0]), strcmp);
                }
             }
       }
       rval=close(fd);
       qsort(darray, dinx, sizeof(darray[0]), strcmp);
       while (i < dinx)
       {
             printf("%s\n", darray[i]);
             i++;
       }
    }
    else
    {
       printf("Open failed\n");
    }
 }
}


/* Function that adds no_of_days to Date d */
void add_day(Date *d, int no_of_days)
{
   Date temp;  /* Date for temporary storage during calculation */
   int days_of_this_month, days_of_next_month, days_to_be_added,
       days_of_month[14] = {0, 31, 28, 31, 30, 31, 30,
                            31, 31, 30, 31, 30, 31, 31};

   temp.day = d->day;
   temp.month = d->month;
   temp.year = d->year;

   while (no_of_days > 0) {
      if (temp.month == 2)
         days_of_this_month = temp.year % 4 == 0 &&
                              (temp.year % 100 != 0 || temp.year % 400 == 0)
                              ? 29 : 28;
      else
         days_of_this_month = days_of_month[temp.month];

      if (temp.day < days_of_this_month) {
         days_to_be_added = no_of_days < days_of_this_month - temp.day
                            ? no_of_days : days_of_this_month - temp.day;
         no_of_days -= days_to_be_added;
         temp.day += days_to_be_added;
      }
      else {
         temp.month++;

         if (temp.month == 2)
            days_of_next_month = temp.year % 4 == 0 &&
                                 (temp.year % 100 != 0 ||
                                 temp.year % 400 == 0) ? 29 : 28;
         else
            days_of_next_month = days_of_month[temp.month];

         days_to_be_added = no_of_days < days_of_next_month
                            ? no_of_days : days_of_next_month;
         no_of_days -= days_to_be_added;
         temp.day = days_to_be_added;
      }
   }

   d->day = temp.day;
//   d->month = temp.month;
   if (temp.month != 13)
      d->month = temp.month;
   else
   {
      d->month = 1;
      temp.year++;
   }
   d->year = temp.year;
}

/* Returns day number when passed year, month and day */
int DOW(int y, int m, int d)
{
      if (m < 3)
      {
            m += 13;
            y--;
      }
      else  m++;
      return (d + 26 * m / 10 + y + y / 4 - y / 100 + y / 400 + 5) % 7;
}
