#if defined(__TURBOC__)
#define	TURBOC
#endif
/* INTERFAC.H  */
   #define  CLASS_BASE     0x40
   #define  FNCT_BASE      0x01

#define SC_DB1     ((CLASS_BASE + 27)*256 + FNCT_BASE)
#define SC_DB2     ((CLASS_BASE + 28)*256 + FNCT_BASE)

#define F_DB_CREATE                (SC_DB1 +  0)
#define F_DB_OPEN                  (SC_DB1 +  1)
#define F_DB_FLUSHFILE             (SC_DB1 +  2)
#define F_DB_CLOSE                 (SC_DB1 +  3)
#define F_DB_SHUTDOWN              (SC_DB1 +  4)
#define F_DB_READRECORD            (SC_DB1 +  5)
#define F_DB_RECORDSIZE            (SC_DB1 +  6)
#define F_DB_NEXTRECORD            (SC_DB1 +  7)
#define F_DB_WRITERECORD           (SC_DB1 +  8)
#define F_DB_DELETERECORD          (SC_DB1 +  9)
#define F_DB_LOADFIELDDEFS         (SC_DB1 + 10)
#define F_DB_GETFIELD              (SC_DB1 + 11)
#define F_DB_GETFIELDSTRINGS       (SC_DB1 + 12)
#define F_DB_DEFAULTCALLBACK       (SC_DB1 + 13)
#define F_DB_GETFIELDNAME          (SC_DB1 + 14)
#define F_DB_GETFIELDINDEX         (SC_DB1 + 15)
#define F_DB_CREATELOOKUPTABLE     (SC_DB1 + 16)
#define F_DB_ORDER                 (SC_DB1 + 17)
#define F_DB_CREATEVIEWPTTABLE     (SC_DB1 + 18)
#define F_DB_MODIFYVIEWPT          (SC_DB1 + 19)
#define F_DB_SETCURRENTVIEWPT      (SC_DB1 + 20)
#define F_DB_STOREVIEWPT           (SC_DB1 + 21)
#define F_DB_INVIEWPT              (SC_DB1 + 22)
#define F_DB_FINDRECORD            (SC_DB1 + 23)
#define F_DB_FINDMEMORYRECORD      (SC_DB1 + 24)
#define F_DB_FINDDATARECORD        (SC_DB1 + 25)
#define F_DB_GETTIMESTAMP          (SC_DB1 + 26)
#define F_DB_GETDATE               (SC_DB1 + 27)
#define F_DB_GETTIME               (SC_DB1 + 28)
#define F_DB_TIMETOSTRING          (SC_DB1 + 29)
#define F_DB_DATETOSTRING          (SC_DB1 + 30)
#define F_DB_STRINGTODATE          (SC_DB1 + 31)
#define F_DB_STRINGTOTIME          (SC_DB1 + 32)
#define F_ENCODE                   (SC_DB1 + 33)
#define F_AVAILLOOKUPENTRY         (SC_DB1 + 34)
#define F_DB_WINTRANSLATE          (SC_DB1 + 35)


#define F_DB_INIT                  (SC_DB2 +  0)
#define F_DB_RESET                 (SC_DB2 +  1)
#define F_DB_DEACTIVATE            (SC_DB2 +  2)
#define F_DB_REACTIVATE            (SC_DB2 +  3)
#define F_DB_ISSELECTED            (SC_DB2 +  4)
#define F_DB_SELECT                (SC_DB2 +  5)
#define F_DB_COLLECTGARBAGE        (SC_DB2 +  6)
#define F_DB_UNDO                  (SC_DB2 +  7)
#define F_DB_SETUNDOPOINT_         (SC_DB2 +  8)
#define F_DB_PARSEFISL             (SC_DB2 +  9)
#define F_DB_CHANGEPASSWORD        (SC_DB2 + 10)
#define F_DB_VERIFYPASSWORD        (SC_DB2 + 11)
#define F_DB_AUTOGOTO              (SC_DB2 + 12)
#define F_DB_CARDTOFISL            (SC_DB2 + 13)
#define F_DB_FISLTOCARD            (SC_DB2 + 14)
#define F_DB_COMPRESSDELETE        (SC_DB2 + 15)
#define F_DB_WRITEINPLACE          (SC_DB2 + 16)
#define F_DB_NEXTNEXTRECORD        (SC_DB2 + 17)
#define F_DB_COPYRECORD            (SC_DB2 + 18)
#define F_DB_CHECKCATEGORY         (SC_DB2 + 19)
#define F_DB_FIELDINFISL           (SC_DB2 + 20)
#define F_DB_FISLFIELDTRANSLATE    (SC_DB2 + 21)
#define F_DB_UNPARSEFISL           (SC_DB2 + 22)
#define F_DB_CREATEVIEWPTINMEMORY  (SC_DB2 + 23)
#define F_DB_CARDCHANGED           (SC_DB2 + 24)
#define F_DB_WINSTRTO850           (SC_DB2 + 25)
#define F_DB_WINGLEDTO850          (SC_DB2 + 26)
#define F_DB_ADVANCEFISL           (SC_DB2 + 27)
#define APP_NEAR near

#ifndef _DB_TIMESTAMP_
typedef unsigned char DB_DATE[3];
typedef int DB_TIME;

typedef struct {
  DB_DATE date;
  DB_TIME time;
  } DB_TIMESTAMP;

#define GetDate(date)     c_service2(F_DB_GETDATE,(void *)(date))
#define GetTime(time)     c_service2(F_DB_GETTIME,(void *)(time))
#define GetTimeStamp(ts)  c_service2(F_DB_GETTIMESTAMP,(void *)(ts))
#define TimeToString(time,string) \
        c_service2(F_DB_TIMETOSTRING,(void far *)(time),(void far *)(string))
#define DateToString(date,string) \
      c_service2(F_DB_DATETOSTRING,(void far *)(date),(void far *)(string))
#define StringToDate(string,date) \
        c_service2(F_DB_STRINGTODATE,(void far *)(string),(void far *)(date))
#define StringToTime(string,time) \
        c_service2(F_DB_STRINGTOTIME,(void far *)(string),(void far *)(time))
#define _DB_TIMESTAMP_
#endif
#ifndef NULL
#define NULL 0
#endif

#define DB_VER 0x102
#define DB_TYPES 32
#define DB_FIELDS 32

#define DB_SORTFIELDS 3
#define DB_MAXVIEWPTS 16

#define DB_MAXDIGITS  16

#define DB_MAXPASSWORD 16

#define DB_MAXSTRING 256

#define DB_MAXFINDFIELDS 64

#define DB_FIELDNAMELENGTH 20

#define DB_FINDSTRINGLENGTH 64

#define DB_VIEWPTNAMELENGTH 31

#define DB_LINKNAMELENGTH (DB_VIEWPTNAMELENGTH)


#define DB_CATEGORYSEPARATOR ';'

enum DB_Errors {
DB_OK=0,
DB_NOTFOUND=-1,
DB_DELETED=-2,
DB_OPEN=-3,
DB_CLOSE=-4,
DB_READ=-5,
DB_WRITE=-6,
DB_SIGNATURE=-7,
DB_CREATE=-8,
DB_SEEK=-9,

DB_SYNTAX=-10,
DB_OVERFLOW=-11,
DB_COMPLEX=-12,
DB_TYPEMISMATCH=-13,

DB_NOFIELD=-14,
DB_NOCALLBACK=-15,
DB_LARGEVIEWPT=-16,
DB_VPABSENT=-17,

DB_CANTUNDO=-18,

DB_MEMORY=-19,

DB_PASSWORDFAILED=-20,
DB_MAYBEINUSE=-21,
DB_RELEASE=-22,
DB_FILETYPE=-23,

DB_ILLEGAL=-24,
DB_USERABORT=-25,

DB_CORRUPT=-26,
DB_SORTCHANGE=-27,
DB_PROTECTED=-28
};

enum DB_ModifyViewptTypes {
MVP_DELETE,
MVP_MODIFY,
MVP_ADD
};

enum DB_UndoActions {
UNDO_DELETED,
UNDO_MODIFIED,
UNDO_ADDED
};

#define DB_US_UNDO 1

#define DB_VIEWPTTOUCHED 2

#define DB_OPENDATABASE  4

#define DB_OPENHANDLE    8

#define DB_SHOULDFLUSH   16

#define DB_BEINGCREATED  32

#define DB_NEEDSGC       64

#define DB_WASTRANSLATED 128

#define DB_FIND_AUTOGOTO 0x8000
#define DB_FIND_DIRECT 0x4000
#define DB_FIND_NOTES 0x2000
#define DB_FIND_CASE 0x1000
#define DB_FIND_FIRST 0x0800
#define STATUS_DBACTIVE 1
#define STATUS_MODIFIED 2
#define STATUS_GARBAGE 1
#define STATUS_MODIFIED 2
#define STATUS_DELETED   128
#define STATUS_WASDELETED 64
#define STATUS_SELECTED   32
enum FieldTypes {
BYTEBOOL_FIELD,
WORDBOOL_FIELD,
STRING_FIELD,
PHONE_FIELD,
NUMBER_FIELD,
CURRENCY_FIELD,
CATEGORY_FIELD,
TIME_FIELD,
DATE_FIELD,
RADIO_FIELD,
NOTE_FIELD,
GROUP_FIELD,
STATIC_FIELD,
MULTILINE_FIELD,
LIST_FIELD,
COMBO_FIELD,
USER_FIELD,
};
#define FIELDDEF_NODATA   128
#define FIELDDEF_RESERVED  64
#define FIELDDEF_DELETED (128+64)
#define FIELDDEF_RELATIVE  32
#define FIELDDEF_NULLTITLE 16
#define VIEWPT_UNNAMED  1
#define VIEWPT_NODELETE 2
#define VIEWPT_GENERAL  4
#define LINK_NODELETE 2
enum DB_RecordTypes {
TYPE_DBHEADER,
TYPE_PASSWORD,
TYPE_DEFAULT_DATA,
TYPE_CONFIGREC,
TYPE_CARDDEF,
TYPE_CATEGORY,
TYPE_FIELDDEF,
TYPE_VIEWPTDEF,
TYPE_PRINTDEF,
TYPE_NOTE,
TYPE_VIEWPTTABLE,
TYPE_DATA,
TYPE_LINKDEF,
TYPE_CARDPAGEDEF,
TYPE_USER,
TYPE_LOOKUPTABLE=DB_TYPES-1,
};
typedef int RECORDNUM;
typedef long int RECORDOFFSET;
typedef struct {
  unsigned int size;
  unsigned int filters;
  char flags;
  RECORDOFFSET offset;
  RECORDOFFSET undooffset;
} LOOKUPENTRY;
typedef struct {
  unsigned int size;
  unsigned int filters;
  char flags;
  char offset[3];
} PACKEDLOOKUPENTRY;
typedef char FILEID[4];
typedef struct {
  char type;
  char status;
  unsigned int length;
  RECORDNUM record;
} RECORDHEADER;
typedef struct {
  RECORDHEADER rhdr;
  int releasenum;
  char filetype;
  char filestatus;
  RECORDNUM curr_viewpt;
  RECORDNUM numrecords;
  RECORDOFFSET lookupseek;
  DB_TIMESTAMP lastreconciled;
  int magicviewptsort;
} DBHEADER;
typedef struct {
  FILEID signature;
  DBHEADER header;
} DBFILEPREFIX;
#define FIELDDEFSIZEOF(f) (sizeof(FIELDDEF)-DB_FIELDNAMELENGTH+lstrlen((f).name))
typedef struct {
  char fieldtype;
  char fieldID;
  int dataoffset;
  char flags;
  int reserved;
  char name[DB_FIELDNAMELENGTH+1];
} FIELDDEF;
typedef struct {
  char fieldnumber;
  char width;
} COLUMNINFO;
#define DB_NUMBERCOLUMNS 20
typedef struct {
  int tokenlen;
  int stringlen;
  int flags;
  char reserved;
  char name[DB_VIEWPTNAMELENGTH+1];
  int sortfield[3];
  int ascending[3];
  COLUMNINFO arrange[DB_NUMBERCOLUMNS];
} VIEWPTDEF;
typedef struct {
  int stringlen;
  int flags;
  char name[DB_LINKNAMELENGTH+1];
} LINKDEF;
typedef struct {
  char filename[80];
  int handle;
  DBHEADER header;
  unsigned int typefirst[DB_TYPES];
  unsigned int typecount[DB_TYPES];
  LOOKUPENTRY far * APP_NEAR *lookup;
  int far * APP_NEAR *viewpt;
  int viewptcount;
  int lookupmax,viewptmax;
  FIELDDEF far * APP_NEAR *fielddefs;
  int (far *FieldCallBack)();
  unsigned int flags;
  VIEWPTDEF far * APP_NEAR *viewptdef;
  int cardchanges;
  int reserved;
  char password[DB_MAXPASSWORD+1];
  int (far *ROMCallBack)();
  int ROMCount;
} DBBLOCK;
enum CallBackActions {
USERTYPE_TOSTRING,
USERTYPE_FROMSTRING,
USERTYPE_COMPARE,
USERTYPE_CONTAINS,
USERTYPE_FROMSTRINGNORESET,
};
/*
typedef struct {
    PACKEDLOOKUPENTRY entry[10000];
    unsigned int typefirst[32];
  } LOOKUPTABLE;
typedef struct {
   RECORDNUM entry[100];
} VIEWPTTABLE;
typedef struct {
   char category[100];
  } CATEGORY;
*/
typedef struct {
  char Action;           /* What was done to get the Undone record */
  char Type;             /* Type of the undone record */
  RECORDNUM Record;      /* Record number */
} UNDORETURN;

#define DB_GRANULARITY 40
#define STACK_SIZE 15

#define DB_MAXLOOKUPS (DB_GRANULARITY * (65535 / (DB_GRANULARITY * sizeof(LOOKUPENTRY))))

typedef struct {
  char SortKey[DB_MAXDIGITS];
} TempViewptKey;

enum FISLTokens {
ERROR_TOKEN,
NOT_TOKEN,
OR_TOKEN,
AND_TOKEN,
EQ_TOKEN,
LE_TOKEN,
LT_TOKEN,
GE_TOKEN,
GT_TOKEN,
NE_TOKEN,
IN_TOKEN,
CONTAINS_TOKEN,
LPAREN_TOKEN,
RPAREN_TOKEN,
SEPARATOR_TOKEN,
TO_TOKEN,
NUMBER_TOKEN,
STRING_TOKEN,
NAME_TOKEN,
BOOLNAME_TOKEN,
TIME_TOKEN,
DATE_TOKEN,
CATEGORY_TOKEN,
USERTYPE_TOKEN,
EOL_TOKEN,
PLACEHOLDER_TOKEN,
STAR_TOKEN,
};
#define Encode(password,record,size,offset) \
c_service2(F_ENCODE,(void far *)(password),(void far *)(record), (size), (offset))

#define AvailLookupEntry(dblk,recordtype) \
c_service2(F_AVAILLOOKUPENTRY,(void *)(dblk),(recordtype))

#define DB_Init() c_service2(F_DB_INIT)

#define DB_Create(dblk,filename,filetype,FieldCallBack,ROMCount,ROMCallBack) \
c_service2(F_DB_CREATE,(void near *)(dblk),(void near *)(filename),(filetype),\
        (void far  *)(FieldCallBack),(ROMCount),(void far *)(ROMCallBack))

#define DB_Open(dblk,filename,filetype,FieldCallBack,password,ROMCount,ROMCallBack) \
c_service2(F_DB_OPEN,(void *)(dblk),(void *)(filename),(filetype), \
  (void far *)(FieldCallBack),(password),(ROMCount),(void far *)(ROMCallBack))

#define DB_Deactivate(dblk) c_service2(F_DB_DEACTIVATE,(void *)(dblk))

#define DB_Reactivate(dblk) c_service2(F_DB_REACTIVATE,(void *)(dblk))


#define DB_Close(dblk) c_service2(F_DB_CLOSE,(void *)(dblk))

#define DB_ShutDown(dblk) c_service2(F_DB_SHUTDOWN,(void *)(dblk))

#define DB_ReadRecord(dblk,recordtype,recordnum,dest,bufsize,sizeread) \
c_service2(F_DB_READRECORD,(void *)(dblk),(recordtype),(recordnum),  \
           (void far *)(dest),(bufsize),(void *)(sizeread))


#define DB_WriteRecord(dblk,recordtype,recordnum,src,recsize,viewptindex) \
c_service2(F_DB_WRITERECORD,(void *)(dblk),(recordtype),(recordnum),  \
         (void far *)(src),(recsize),(void *)(viewptindex))


#define DB_WriteInPlace(dblk,recordtype,recordnum,recoffset,src,recsize) \
c_service2(F_DB_WRITEINPLACE,(void *)(dblk),(recordtype),(recordnum),  \
         (recoffset),(void far *)(src),(recsize))

#define DB_DeleteRecord(dblk,recordtype,recordnum,viewptindex) \
c_service2(F_DB_DELETERECORD,(void *)(dblk),(recordtype),(recordnum),  \
           (void *)(viewptindex))

#define DB_CompressDelete(dblk,recordtype,recordnum) \
c_service2(F_DB_COMPRESSDELETE,(void *)(dblk),(recordtype),(recordnum))

#define DB_RecordSize(dblk,recordtype,recordnum) \
c_service2(F_DB_RECORDSIZE,(void *)(dblk),(recordtype),(recordnum))

#define DB_NextRecord(dblk,recordtype) \
c_service2(F_DB_NEXTRECORD,(void *)(dblk),(recordtype))

#define DB_NextNextRecord(dblk,recordtype) \
c_service2(F_DB_NEXTNEXTRECORD,(void *)(dblk),(recordtype))

#define DB_CopyRecord(dbto,dblk,recordtype,recordnum) \
c_service2(F_DB_COPYRECORD,(void *)(dbto),(void *)(dblk),(recordtype),(recordnum))

#define DB_CreateLookupTable(dblk) \
c_service2(F_DB_CREATELOOKUPTABLE,(void *)(dblk))

#define DB_CreateViewptTable(dblk) \
c_service2(F_DB_CREATEVIEWPTTABLE,(void *)(dblk))

#define DB_CreateViewptInMemory(dblk) \
c_service2(F_DB_CREATEVIEWPTINMEMORY,(void *)(dblk))

#define DB_CollectGarbage(dblk) \
c_service2(F_DB_COLLECTGARBAGE,(void *)(dblk))

#define DB_FlushFile(dblk) \
c_service2(F_DB_FLUSHFILE,(void *)(dblk))

#define DB_Select(dblk,recordnum,status) \
c_service2(F_DB_SELECT,(void *)(dblk),(recordnum),(status))

#define DB_IsSelected(dblk,recordnum) \
c_service2(F_DB_ISSELECTED,(void *)(dblk),(recordnum))

#define DB_Reset(filename) c_service2(F_DB_RESET,(void *)(filename))

#define DB_ChangePassword(dblk,oldpassword,newpassword) \
c_service2(F_DB_CHANGEPASSWORD,(void *)(dblk),(void *)(oldpassword), \
         (void *)(newpassword))

#define DB_VerifyPassword(dblk,password)\
c_service2(F_DB_VERIFYPASSWORD,(void *)(dblk),(void *)(password))

#define DB_SetUndoPoint_(dblk) \
c_service2(F_DB_SETUNDOPOINT_,(void *)(dblk))

#define DB_Undo(dblk,undocount,undoret) \
c_service2(F_DB_UNDO,(void *)(dblk),(void *)(undocount),(void *)(undoret))

#define DB_LoadFieldDefs(dblk) \
c_service2(F_DB_LOADFIELDDEFS,(void *)(dblk))

#define DB_GetField(dblk,srcrec,index,string,bufsize) \
c_service2(F_DB_GETFIELD,(void *)(dblk),(void far *)(srcrec), \
         (index),(void far *)(string),(bufsize))

#define DB_GetFieldStrings(dblk,srcrec,indextable,ptrtable,indexcount,buffer,bufsize) \
c_service2(F_DB_GETFIELDSTRINGS,(void *)(dblk),(void far *)(srcrec), \
         (void far *)(indextable),(void far *)(ptrtable),(indexcount),\
         (void far *)(buffer),(bufsize))

#define DB_GetFieldName(dblk,index,name) \
c_service2(F_DB_GETFIELDNAME,(void *)(dblk),index,(void far  *)(name))

#define DB_GetFieldIndex(dblk,name) \
c_service2(F_DB_GETFIELDINDEX,(void *)(dblk),(void far *)(name))

#define DB_Order(dblk,recnum1,rec1,recnum2,rec2) \
c_service2(F_DB_ORDER,(void *)(dblk),(recnum1), \
         (void far *)(rec1),(recnum2),(void far *)(rec2))

#define DB_DefaultCallBack(dblk,action,buffersize,intarg,arg1,arg2) \
c_service2(F_DB_DEFAULTCALLBACK,(void *)(dblk),(action), \
         (buffersize),(intarg),(void far *)(arg1),(void far *)(arg2))

#define DB_ParseFISL(dblk,InFISL,OutTOKEN,OutBufSize,OutExpLen) \
c_service2(F_DB_PARSEFISL,(void *)(dblk),(void far *)(InFISL), \
         (void far *)(OutTOKEN),(OutBufSize),(void *)(OutExpLen))

#define DB_InViewpt(dblk,src,viewptdef) \
c_service2(F_DB_INVIEWPT,(void *)(dblk),(void far *)(src), \
         (void *)(viewptdef))

#define DB_ModifyViewpt(dblk,recordnum,src,action) \
c_service2(F_DB_MODIFYVIEWPT,(void *)(dblk),(recordnum),(void far *)(src), \
         (action))

#define DB_SetCurrentViewpt(dblk,viewptnum) \
c_service2(F_DB_SETCURRENTVIEWPT,(void *)(dblk),(viewptnum))

#define DB_StoreViewpt(dblk,viewptnum,viewptdef) \
c_service2(F_DB_STOREVIEWPT,(void *)(dblk),(viewptnum), \
                  (void far *)viewptdef)

#define DB_FindRecord(dblk,recordtype,searchstring,begin,end,flags,pos) \
c_service2(F_DB_FINDRECORD,(void *)(dblk),(recordtype), \
         (void far *)(searchstring),(begin),(end),(flags),(void far *)(pos))

#define DB_FindMemoryRecord(dblk,buffer,searchstring,flags,field,pos) \
c_service2(F_DB_FINDMEMORYRECORD,(void *)(dblk), (void far *)(buffer), \
   (void far *)(searchstring),(flags),(void far *)(field),(void far *)(pos))

#define DB_FindDataRecord(dblk,searchstring,begin,end,flags,field,pos) \
c_service2(F_DB_FINDDATARECORD,(void *)(dblk),(void far *)(searchstring),(begin),(end),(flags),(void far *)(field),(void far *)(pos))

#define DB_AutoGoto(dblk,searchstring,begin,end ) \
c_service2(F_DB_AUTOGOTO,(void *)(dblk),(void far *)(searchstring), \
         (begin),(end))

#define DB_CheckCategory(dblk,categoryrecord,CategoryString) \
c_service2(F_DB_CHECKCATEGORY,(void *)(dblk),(categoryrecord), \
         (void far *)(CategoryString))

#define DB_CardToFISL(db,field,fielddata,fislbuffer,fislbuffersize) \
c_service2(F_DB_CARDTOFISL,(void *)(db),(field), \
         (void far *)(fielddata), (void far *)(fislbuffer), (fislbuffersize))

#define DB_FISLToCard(db,index,fislbuffer,fielddata,fielddatasize) \
c_service2(F_DB_FISLTOCARD,(void *)(db),(index), \
         (void far *)(fislbuffer), (void far *)(fielddata), (fielddatasize))

#define DB_FieldInFISL(InTOKEN,tokenlen, fieldcount,fieldnumbers) \
c_service2(F_DB_FIELDINFISL,(void far *)(InTOKEN),(tokenlen),(fieldcount), \
         (void far *)(fieldnumbers))

#define DB_FISLFieldTranslate(InTOKEN,tokenlen, fieldcount,oldfieldnumbers,newfieldnumbers) \
c_service2(F_DB_FISLFIELDTRANSLATE,(void far *)(InTOKEN),(tokenlen),(fieldcount),         (void far *)(oldfieldnumbers),(void far *)(newfieldnumbers))

#define DB_UnparseFISL(dblk,InTOKEN,tokenlen, OutFISL,OutBufSize) \
c_service2(F_DB_UNPARSEFISL,(void *)(dblk),(void far *)(InTOKEN), (tokenlen),\
         (void far *)(OutFISL),(OutBufSize))

#define DB_CardChanged(dblk) \
c_service2(F_DB_CARDCHANGED,(void *)(dblk))

#define DB_WinStrTo850(str) \
c_service2(F_DB_WINSTRTO850,(void far *)(str))

#define DB_WinGledTo850(str,stringlength) \
c_service2(F_DB_WINGLEDTO850,(void far *)(str),stringlength)

#define DB_WinTranslate(dblk) \
c_service2(F_DB_WINTRANSLATE,(void *)(dblk))

#define DB_AdvanceFISL(fisl) \
c_service2(F_DB_ADVANCEFISL,(void far *)(fisl))

#define DB_CancelViewpt(db)           DB_SetCurrentViewpt(db, 0)
#define DB_AddRecord(db,rt,sc,rs,vpi) DB_WriteRecord(db,rt,32767,sc,rs,vpi)
#define DB_CountRecords(db,rt)        ((db)->typecount[rt])
#define DB_UndoStatus(db)             ((db)->flags & DB_US_UNDO)
#define DB_GetNamedField(db,sr,nm,str,bs)  DB_GetField(db,sr,\
                                           DB_GetFieldIndex(db,nm),str,bs)
#define DB_SetUndoPoint(db)           DB_CollectGarbage(db)

