/* --------------------------------------------------------------------
   Project: PAL General Database routines
   Module:  FILTERS.C
   Author:  Jean-Jacques Moreau
   Started: 11. Aug. 99.
   Subject: Manage virtual viewpoints
   -------------------------------------------------------------------- */

/* --------------------------------------------------------------------
                          standard includes
   -------------------------------------------------------------------- */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>

/* --------------------------------------------------------------------
                            local includes
   -------------------------------------------------------------------- */

#include "pal.h"


/* -------------------------------------------------------------------------
                           Add a record to a table
   ------------------------------------------------------------------------- */

static int GrowRecTable(DBDESC *pDD, int *pTable, WORD *pNumRecs, WORD RecNum)
{
   int *pDest;

   if(!pTable) {
      pDD->ErrorMsg = INVALID_VIEWPOINT;
      return FALSE;
   }

   pDest = pTable + (int) *pNumRecs;
   *pDest = RecNum;
   (*pNumRecs)++;

   pDD->ErrorMsg = OPERATION_OK;
   return TRUE;
}


/* -------------------------------------------------------------------------
                           Remove a record from its table
   ------------------------------------------------------------------------- */

static int ShrinkRecTable(DBDESC *pDD, int *pTable, WORD *pNumRecs, WORD RecNum)
{
   int *pSource, *pDest;

   if(!pTable) {
      pDD->ErrorMsg = INVALID_VIEWPOINT;
      return FALSE;
   }

   if (((*pNumRecs) == 0) || (RecNum < 0) || (RecNum > (*pNumRecs)-1)){
      pDD->ErrorMsg = RECORD_NOT_FOUND;
      return FALSE;
   }

   pDest = pTable + (int) RecNum;
   pSource = pDest + 1;
   memmove(pDest, pSource, ((*pNumRecs)-(RecNum+1))*sizeof(int));
   (*pNumRecs)--;

   pDD->ErrorMsg = OPERATION_OK;
   return TRUE;
}


/* -------------------------------------------------------------------------
                           Filter the current record
   ------------------------------------------------------------------------- */

static WORD RelRecIndex(int *pTable, WORD NumRecs, WORD AbsRecNum)
{
   int i;

   for(i=0; i<NumRecs; i++) {
      if (*pTable == AbsRecNum)
         return i;
      pTable++;
   }

   return -1;
}


/* -------------------------------------------------------------------------
                           Filter the current record
   ------------------------------------------------------------------------- */

int FilterRecAtIndex(DBDESC *pDD, WORD RecNum)
{
   WORD AbsRecNum, RelRecNum;

   if (!pDD)
      return TRUE;

   /* update indexes */
   switch (pDD->XTickMode) {
      case NO_FILTER:
         if (pDD->pXTICKS[RecNum]) { /* untick */
            AbsRecNum = pDD->pVTAB[RecNum];
            RelRecNum = RelRecIndex(pDD->pXTAB, pDD->XNumDataRec, AbsRecNum);
            ShrinkRecTable(pDD, pDD->pXTAB, &pDD->XNumDataRec, RelRecNum);
            GrowRecTable(pDD, pDD->pYTAB, &pDD->YNumDataRec, AbsRecNum);

            pDD->pXTICKS[RecNum] = 0;
         } else { /*tick */
            AbsRecNum = pDD->pVTAB[RecNum];
            GrowRecTable(pDD, pDD->pXTAB, &pDD->XNumDataRec, AbsRecNum);
            RelRecNum = RelRecIndex(pDD->pYTAB, pDD->YNumDataRec, AbsRecNum);
            ShrinkRecTable(pDD, pDD->pYTAB, &pDD->YNumDataRec, RelRecNum);

            pDD->pXTICKS[RecNum] = 1;
         }
         break;

      case TICKS_FILTER:
         AbsRecNum = pDD->pXTAB[RecNum];
         ShrinkRecTable(pDD, pDD->pXTAB, &pDD->XNumDataRec, RecNum);
         GrowRecTable(pDD, pDD->pYTAB, &pDD->YNumDataRec, AbsRecNum);

         RelRecNum = RelRecIndex(pDD->pVTAB, pDD->NumDataRec, AbsRecNum);
         pDD->pXTICKS[RelRecNum] = 0;

         break;

      case ALLBUT_FILTER:
         AbsRecNum = pDD->pYTAB[RecNum];
         ShrinkRecTable(pDD, pDD->pYTAB, &pDD->YNumDataRec, RecNum);
         GrowRecTable(pDD, pDD->pXTAB, &pDD->XNumDataRec, AbsRecNum);

         RelRecNum = RelRecIndex(pDD->pVTAB, pDD->NumDataRec, AbsRecNum);
         pDD->pXTICKS[RelRecNum] = 1;

         break;

      default:
         break;
   }

   pDD->ErrorMsg = OPERATION_OK;
   return TRUE;
}


/* -------------------------------------------------------------------------
                           Filter all records
   ------------------------------------------------------------------------- */

int FilterAllRec(DBDESC *pDD, BYTE Set)
{
   WORD i;

   memset(pDD->pXTICKS, Set, pDD->NumDataRec*sizeof(BYTE));

   if (Set) { /* tick? */
      memcpy(pDD->pXTAB, pDD->pVTAB, pDD->NumDataRec*sizeof(int));
      pDD->XNumDataRec = pDD->NumDataRec;

      memset(pDD->pYTAB, 0, pDD->NumDataRec*sizeof(int));
      pDD->YNumDataRec = 0;

   } else { /* untick */
      memcpy(pDD->pYTAB, pDD->pVTAB, pDD->NumDataRec*sizeof(int));
      pDD->YNumDataRec = pDD->NumDataRec;

      memset(pDD->pXTAB, 0, pDD->NumDataRec*sizeof(int));
      pDD->XNumDataRec = 0;

   }
}