/*@DB 2 CSV ver 0.2  Feb1,1999  */

#include	"lxapi.h"
#include	"dbapi.h"
#include	<string.h>
#include	<stddef.h>
#include	<stdlib.h>
#include	<ctype.h>

#define 	FP_ENTRY        143
#define 	USER_FP_ENTRY   100
#define		LISTCOUNT		128
#define		DIRCOUNT		64
#define		LF				0x0a
#define		CR				0x0d
#define		ENTER			0x0d
#define		ESC				0x1b
#define		NUL				0x00
#define		DATALEN			4000
#define		RECLEN			4000
#define		TOTALREC		5000



char far *SysMgrPtrs[FP_ENTRY];
char msgnull[] =			"";
char msgAppName[] =			"DB2CSV ver 0.2";
char msgF1[] =				"DbFile";
char msgFileOpen[] =		"Open File";
char msgFileFiles[] =		"Files";
char msgFileDirectry[] =	"Directry:";
char msgFileDirectries[] =	"Directories";
char msgF2[] =				"Field";
char msgF3[] =				"CsvFile";
char msgF5[] =				"Option";
char msgOption[] =			"Option";
char msgGroupBoxType[] =	"Type of DB";
char msgButtonGDB[] =		"*.GDB";
char msgButtonPDB[] =		"*.PDB";
char msgButtonNDB[] =		"*.NDB";
char msgGroupBoxCRLF[] =	"CR + LF in Note";
char msgButtonSpace[] =		"Replace to Space";
char msgButtonChar[] =		"Replace to $!";
char msgButtonStrt[] =		"Straight";
char msgF8[] =				"DB2CSV";
char msgF9[] =				"CSV2DB";
char msgF10[] =				"Quit";
char msgCAN[]	=			"Cancel";
char msgOK[]	=			"OK";
char msgMenuDbFile[] =		"&DbFile";
char msgMenuField[] =		"&Field";
char msgMenuCsvFile[] =		"&CsvFile";
char msgMenuOption[] =		"&Option";
char msgMenuD2C[] =			"D&B2CSV";
char msgMenuC2D[] =			"C&SV2DB";
char msgDbFileOpen[] =		"DB File Select";
char msgCsvFileOpen[] =		"CSV File Select";
char msgField[] =			"FIELD Select";
char msgAllField[] =		"All Fields";
char msgMenuQuit[]=			"&Quit";

enum resouce_index {
	MSG_NUL = FP_ENTRY - USER_FP_ENTRY,    
	MSG_APP_NAME,
	MSG_F1,
	MSG_FILE_OPEN,
	MSG_FILE_FILES,
	MSG_FILE_DIRECTRY,
	MSG_FILE_DIRECTRIES,
	MSG_F2,
	MSG_F3,
	MSG_F5,
	MSG_OPTION,
	MSG_GROUPBOX_TYPE,
	MSG_BUTTON_GDB,
	MSG_BUTTON_PDB,
	MSG_BUTTON_NDB,
	MSG_GROUPBOX_CRLF,
	MSG_BUTTON_SPACE,
	MSG_BUTTON_CHAR,
	MSG_BUTTON_STRT,
	MSG_F8,
	MSG_F9,
	MSG_F10,
	MSG_CAN,
	MSG_OK,
	MSG_MENU_DB_FILE,
	MSG_MENU_FIELD,
	MSG_MENU_CSV_FILE,
	MSG_MENU_OPTION,
	MSG_MENU_D2C,
	MSG_MENU_C2D,
	MSG_DB_FILE_OPEN,
	MSG_CSV_FILE_OPEN,
	MSG_FIELD,
	MSG_ALL_FIELD,
	MSG_MENU_QUIT,
};

void InitRscMsgPtr(void)
{
	SysMgrPtrs[MSG_NUL] = 				msgnull;
	SysMgrPtrs[MSG_APP_NAME] = 			msgAppName;
	SysMgrPtrs[MSG_F1] = 				msgF1;
	SysMgrPtrs[MSG_FILE_OPEN] = 		msgFileOpen;
	SysMgrPtrs[MSG_FILE_FILES] = 		msgFileFiles;
	SysMgrPtrs[MSG_FILE_DIRECTRY] = 	msgFileDirectry;
	SysMgrPtrs[MSG_FILE_DIRECTRIES] = 	msgFileDirectries;
	SysMgrPtrs[MSG_F2] = 				msgF2;
	SysMgrPtrs[MSG_F3] = 				msgF3;
	SysMgrPtrs[MSG_F5] = 				msgF5;
	SysMgrPtrs[MSG_OPTION] = 			msgOption;
	SysMgrPtrs[MSG_GROUPBOX_TYPE] = 	msgGroupBoxType;
	SysMgrPtrs[MSG_BUTTON_GDB] = 		msgButtonGDB;
	SysMgrPtrs[MSG_BUTTON_PDB] = 		msgButtonPDB;
	SysMgrPtrs[MSG_BUTTON_NDB] = 		msgButtonNDB;
	SysMgrPtrs[MSG_GROUPBOX_CRLF] = 	msgGroupBoxCRLF;
	SysMgrPtrs[MSG_BUTTON_SPACE] = 		msgButtonSpace;
	SysMgrPtrs[MSG_BUTTON_CHAR] =		msgButtonChar;
	SysMgrPtrs[MSG_BUTTON_STRT] = 		msgButtonStrt;
	SysMgrPtrs[MSG_F8] = 				msgF8;
	SysMgrPtrs[MSG_F9] = 				msgF9;
	SysMgrPtrs[MSG_F10] = 				msgF10;
	SysMgrPtrs[MSG_CAN] = 				msgCAN;
	SysMgrPtrs[MSG_OK] = 				msgOK;
	SysMgrPtrs[MSG_MENU_DB_FILE] = 		msgMenuDbFile;
	SysMgrPtrs[MSG_MENU_FIELD] = 		msgMenuField;
	SysMgrPtrs[MSG_MENU_CSV_FILE] = 	msgMenuCsvFile;
	SysMgrPtrs[MSG_MENU_OPTION] =		msgMenuOption;
	SysMgrPtrs[MSG_MENU_D2C] = 			msgMenuD2C;
	SysMgrPtrs[MSG_MENU_C2D] = 			msgMenuC2D;
	SysMgrPtrs[MSG_DB_FILE_OPEN] = 		msgDbFileOpen;
	SysMgrPtrs[MSG_CSV_FILE_OPEN] = 	msgCsvFileOpen;
	SysMgrPtrs[MSG_FIELD] = 			msgField;
	SysMgrPtrs[MSG_ALL_FIELD] = 		msgAllField;
	SysMgrPtrs[MSG_MENU_QUIT] = 		msgMenuQuit;

}



void far DoDbFile( void );
void far DoField(void);
void far DoCsvFile( void );
void far DoOption(void);
void far DoD2C(void);
void far DoC2D(void);
void far DoQuit(void);

int far MainHandler(PLHWINDOW Wnd, WORD Message, WORD Data, WORD Extra,...);
int far DbFileHandler(PLHWINDOW Wnd,WORD Message, WORD Data, WORD Extra,...);
int far FieldHandler(PLHWINDOW Wnd, WORD Message, WORD Data, WORD Extra,...);
int far CsvFileHandler(PLHWINDOW Wnd,WORD Message, WORD Data, WORD Extra,...);
int far ListBoxHandler(PLHWINDOW Wnd,WORD Message, WORD Data, WORD Extra,...);
int far OptionHandler(PLHWINDOW Wnd,WORD Message, WORD Data, WORD Extra,...);

int	TotalRec;
int	Fieldnum;
int	FlagAllField;
int	MaxIndex;
int	MaxNote=-1;
int	DataTop=0;
int	TotalTbl;
int	IdxTbl[100];
int	LstTbl[100];
int	FlagType;
int	FlagCrlf;

char 	FileNameBuffer[35];
char 	DirNameBuffer[48];
char 	DefaultFileName[16]=	"*.TXT";
char 	DefaultDirName[48]=		"A:\\";
char 	DefaultDirNameCfg[48]=	"A:\\";
char 	DefaultDirNameList[48]=	"A:\\";
char 	PathNameDb[48]=		"";
char 	PathNameCsv[48]=	"";
char	FileType = 				'D';
char	Paswd[] = 				"";
char	*FieldListArray[100];
char	ZeroField[11] ="          ";
char	FieldName[15][80];
unsigned char	RecordData[RECLEN];
unsigned char	RecordDataFix[RECLEN];
char	Crlf[3]={CR,LF,0};

void	Read_Field( void );
void	DB2CSV_Record( void );
void	CSV2DB_Record( void );
void	DB2CSV_Conv(unsigned char *, unsigned char *, unsigned char);
void	CSV2DB_Conv(unsigned char *, unsigned char *, unsigned char);
/*
void	ClearRecord (unsigned char *, int);
*/

int		Init_DB(void);
int		sprintf(char *, const char*, ...);
int		sscanf(const char*, const char *, ...);
int		m_readline(FILE *, unsigned char *);
void	m_readrec(char *, int *, int *);
int		numcheck(char *);

BOOL    Done;
LHAPIBLOCK  CapData;
EVENT    app_event;
DBBLOCK dblk;

typedef struct  {
	int	index;
	int	ptr;
	unsigned char type;
	char	name[40];
} DATAREC;

DATAREC	FieldData[100];

LHFKEY ChoseFkeys[] = {
	{ (PLHRES)&SysMgrPtrs[MSG_CAN], (PLHFUNC)CMD_ESC, 9, FKEY_SENDMSG },
	{ (PLHRES)&SysMgrPtrs[MSG_OK],(PLHFUNC)CMD_DONE, 10+FKEY_LAST, FKEY_SENDMSG }
};


LHFKEY MainFKeys[]= {
  { (PLHRES)&SysMgrPtrs[MSG_F1], (PLHFUNC)DoDbFile,1, 0 },
  { (PLHRES)&SysMgrPtrs[MSG_F2], (PLHFUNC)DoField,2, 0 },
  { (PLHRES)&SysMgrPtrs[MSG_F3], (PLHFUNC)DoCsvFile,3, 0 },
  { (PLHRES)&SysMgrPtrs[MSG_F5], (PLHFUNC)DoOption,5, 0 },
  { (PLHRES)&SysMgrPtrs[MSG_F8], (PLHFUNC)DoD2C,8, 0 },
  { (PLHRES)&SysMgrPtrs[MSG_F9], (PLHFUNC)DoC2D,9, 0 },
  { (PLHRES)&SysMgrPtrs[MSG_F10], (PLHFUNC)DoQuit,10+FKEY_LAST, 0 },
};


LHMENU MainMenu[] = {
  {(PLHRES)&SysMgrPtrs[MSG_MENU_DB_FILE],  (PLHFUNC)DoDbFile,  0, 0, NO_HELP },
  {(PLHRES)&SysMgrPtrs[MSG_MENU_FIELD],  (PLHFUNC)DoField,	0, 0, NO_HELP },
  {(PLHRES)&SysMgrPtrs[MSG_MENU_CSV_FILE],  (PLHFUNC)DoCsvFile,  0, 0, NO_HELP },
  {(PLHRES)&SysMgrPtrs[MSG_MENU_OPTION],    (PLHFUNC)DoOption,	0, 0, NO_HELP },
  {(PLHRES)&SysMgrPtrs[MSG_MENU_D2C],    (PLHFUNC)DoD2C,	0, 0, NO_HELP },
  {(PLHRES)&SysMgrPtrs[MSG_MENU_D2C],    (PLHFUNC)DoC2D,	0, 0, NO_HELP },
  {(PLHRES)&SysMgrPtrs[MSG_MENU_QUIT],  (PLHFUNC)DoQuit,	0, 0, NO_HELP },
  { 0, 0, 0, 0}
};


/* Main */

LHWINDOW MainView = {
  (PLHCLASS)MainHandler, 0, 0, 640, 190,
  (PLHRES)&SysMgrPtrs[MSG_NUL], NULL, 0, 0,
  NULL, MainFKeys, MainMenu, NO_HELP
};

LHWINDOW TDateTime = {
		DateTime, 0, 0, 0, 0,
		0, 0, 0, STYLE_DATETIME|STYLE_NOFOCUS,
		NULL, NO_FKEYS, NO_MENU, NO_HELP
};

LHWINDOW MainTitle = {
		TitleBar, 0, 0, 0, 0,
		(PLHRES)&SysMgrPtrs[MSG_APP_NAME], 0, 0, STYLE_NOFOCUS,
		NULL, NO_FKEYS, (PLHMENU)&TDateTime, NO_HELP,
		0,0,0,FONT_NORM,
};

int far MainHandler(PLHWINDOW Wnd, WORD Message, WORD Data, WORD Extra,...) {
    char temp[80];
    int	idx;
	switch (Message) {
		case KEYSTROKE:
      		if(Data == ESC) {Done = TRUE; return TRUE;}
			break;
		case DRAW:
			ClearRect(Wnd->x,Wnd->y+8,Wnd->w,Wnd->h);
			Outline(  25, 45, 590, 100,1);
			Line(     25, 65, 615,  65,1);
			Line(     25, 85, 615,  85,1);
			Line(     25,105, 615, 105,1);
			Line(     25,125, 615, 125,1);
			Line(    105, 45, 105, 145,1);
			Line(    320, 45, 320, 145,1);
			Line(    400, 45, 400, 145,1);
			
			if(FlagAllField==1)	DrawText( 100, 20, "All Fields" ,DRAW_NORMAL,FONT_NORMAL);
			sprintf(temp,"DB  File: %s",PathNameDb);
			DrawText( 100, 155, temp ,DRAW_NORMAL,FONT_NORMAL);
			sprintf(temp,"CSV File: %s",PathNameCsv);
			DrawText( 100, 170, temp ,DRAW_NORMAL,FONT_NORMAL);
			for(idx=0; idx<5; idx++){
				sprintf(temp,"%s       ",FieldName[idx]);
				temp[7]=NUL;
				DrawText( 30, 50+idx*20, temp, DRAW_NORMAL,FONT_NORMAL);
			}
			for(; idx<10; idx++){
				sprintf(temp,"%s       ",FieldName[idx]);
				temp[7]=NUL;
				DrawText( 325, idx*20-50, temp, DRAW_NORMAL,FONT_NORMAL);
			}
			break;
	}
	return SubclassMsg(Object, Wnd, Message, Data, Extra);
}


/* DB FILE OPEN */

LHWINDOW FoArray[] = {
		{PathText, 0, 0, 0, 0,
		(PLHRES)&msgFileOpen, (PLHDATA)FileNameBuffer, 32, STYLE_WHCHAR,
		NULL, PARENT_FKEYS, (PLHMENU)DefaultFileName, NO_HELP},
		{StaticText, 0, 0, 0, 0,
		(PLHRES)&msgFileDirectry, (PLHDATA)DirNameBuffer,
		48, STYLE_NOBORDER|STYLE_WHCHAR,
		NULL, PARENT_FKEYS, NO_MENU, NO_HELP},
		{FileListBox, 0, 0, 0, 0,
		(PLHRES)&msgFileFiles, NULL, LISTCOUNT, STYLE_WHCHAR|STYLE_NOTIFY,
		NULL, PARENT_FKEYS, (PLHMENU)LISTCOUNT, NO_HELP},
		{DirListBox, 0, 0, 0, 0,
		(PLHRES)&msgFileDirectries, NULL, DIRCOUNT, STYLE_WHCHAR|STYLE_NOTIFY,
		NULL, PARENT_FKEYS, (PLHMENU)DIRCOUNT, NO_HELP},
		{PushButton, 0, 0, 0, 0,
		(PLHRES)&SysMgrPtrs[MSG_OK], (PLHDATA)CMD_DONE, 0, PUSHB_SENDMSG|STYLE_PUSHBUTTON,
		NULL, PARENT_FKEYS, NO_MENU, NO_HELP},
		{PushButton, 0, 0, 0, 0,
		(PLHRES)&SysMgrPtrs[MSG_CAN], (PLHDATA)CMD_ESC, 0, PUSHB_SENDMSG|STYLE_PUSHBUTTON,
		NULL, PARENT_FKEYS, NO_MENU, NO_HELP}
};


LHWINDOW DbFileDlg = {
		(PLHCLASS)DbFileHandler, 0, 0, 0, 0,
		(PLHRES)&SysMgrPtrs[MSG_DB_FILE_OPEN], (PLHDATA)FoArray, countof(FoArray), 0,
		NULL, ChoseFkeys, NO_MENU, NO_HELP
};

void far DoDbFile( void )
{
	SendMsg( &DbFileDlg, CREATE, CREATE_FOCUS, 0 );
}

int far DbFileHandler(PLHWINDOW Wnd, WORD Message, WORD Data, WORD Extra,...)
{
int i,plen;
int **TempPtr,**StorePtr;
	switch (Message) {
		case COMMAND:
			if(Data==CMD_DONE){
				strcpy(PathNameDb,DirNameBuffer);
				if(strlen(PathNameDb)>3) strcat(PathNameDb,"\\");
				strcat(PathNameDb,FileNameBuffer);
				plen=strlen(PathNameDb);
				switch(PathNameDb[plen-3]){
					case 'd':
					case 'D':
					case 'p':
					case 'P':
						FileType='D';
						break;
					case 'n':
					case 'N':
						FileType='N';
						break;
/*					case 'w':
					case 'W':
						FileType='W';
						break;
					case 'a':
					case 'A':
						FileType='2';
						break;					*/
					default:
						FileType='D';
						break;
				}
				Read_Field();
				Data=CMD_ESC;
			}
			break;
		case CREATE:
			strcpy( FileNameBuffer, "" );
			strcpy( DirNameBuffer, DefaultDirNameList );
			switch(FlagType){
				case 0:
					strcpy(DefaultFileName,"*.GDB");
					break;
				case 1:
					strcpy(DefaultFileName,"*.PDB");
					break;
				case 2:
					strcpy(DefaultFileName,"*.NDB");
					break;
			}
			TempPtr=m_alloc((LISTCOUNT+DIRCOUNT)*(2+16));
			FoArray[2].Data=(PLHDATA)TempPtr;
			StorePtr=TempPtr+LISTCOUNT;
			for( i = 0; i < (LISTCOUNT); i++ )
				{*TempPtr++=(int *)StorePtr; StorePtr+=8;}
			FoArray[3].Data=(PLHDATA)StorePtr;
			TempPtr=StorePtr+DIRCOUNT;
			for( i = 0; i < (DIRCOUNT); i++ )
				{*StorePtr++=(int *)TempPtr; TempPtr+=8;}
			break;
		case DESTROY:
			strcpy( DefaultDirNameList, DirNameBuffer);
			m_free(FoArray[2].Data);
			break;
	}
	return SubclassMsg(FileOpenDialogBox, Wnd, Message, Data, Extra);
}


/*  CSV File Open   */

LHWINDOW CsvFileDlg = {
		(PLHCLASS)CsvFileHandler, 0, 0, 0, 0,
		(PLHRES)&SysMgrPtrs[MSG_CSV_FILE_OPEN], (PLHDATA)FoArray, countof(FoArray), 0,
		NULL, ChoseFkeys, NO_MENU, NO_HELP
};

void far DoCsvFile( void )
{
	SendMsg( &CsvFileDlg, CREATE, CREATE_FOCUS, 0 );
}

int far CsvFileHandler(PLHWINDOW Wnd, WORD Message, WORD Data, WORD Extra,...)
{
int i;
int **TempPtr,**StorePtr;
	switch (Message) {
		case COMMAND:
			if(Data==CMD_DONE){
				strcpy(PathNameCsv,DirNameBuffer);
				if(strlen(PathNameCsv)>3) strcat(PathNameCsv,"\\");
				strcat(PathNameCsv,FileNameBuffer);
				Data=CMD_ESC;
			}
			break;
		case CREATE:
			strcpy( FileNameBuffer, "" );
			strcpy( DirNameBuffer, DefaultDirNameList );
			strcpy( DefaultFileName,"*.CSV");
			TempPtr=m_alloc((LISTCOUNT+DIRCOUNT)*(2+16));
			FoArray[2].Data=(PLHDATA)TempPtr;
			StorePtr=TempPtr+LISTCOUNT;
			for( i = 0; i < (LISTCOUNT); i++ )
				{*TempPtr++=(int *)StorePtr; StorePtr+=8;}
			FoArray[3].Data=(PLHDATA)StorePtr;
			TempPtr=StorePtr+DIRCOUNT;
			for( i = 0; i < (DIRCOUNT); i++ )
				{*StorePtr++=(int *)TempPtr; TempPtr+=8;}
			break;
		case DESTROY:
			strcpy( DefaultDirNameList, DirNameBuffer);
			m_free(FoArray[2].Data);
			break;
	}
	return SubclassMsg(FileOpenDialogBox, Wnd, Message, Data, Extra);
}


/* Field Select */

LHWINDOW ComboRefList[10];


LHWINDOW FieldArray[] = {
		{CheckBox, 170, 40, 15, 1,
		(PLHRES)&SysMgrPtrs[MSG_ALL_FIELD], (PLHDATA)&FlagAllField, 1, STYLE_WHCHAR,
		CMD_DONE, PARENT_FKEYS, NO_MENU, NO_HELP},

		{ComboBox, 150, 60, 15, 1,
		(PLHRES)&SysMgrPtrs[MSG_NUL], (PLHDATA)FieldName[0], 15, STYLE_WHCHAR|COMBO_NOEDIT,
		NULL, PARENT_FKEYS, (PLHMENU)&ComboRefList[0], NO_HELP},
		{ComboBox, 150, 80, 15, 1,
		(PLHRES)&SysMgrPtrs[MSG_NUL], (PLHDATA)FieldName[1], 15, STYLE_WHCHAR|COMBO_NOEDIT,
		NULL, PARENT_FKEYS, (PLHMENU)&ComboRefList[1], NO_HELP},
		{ComboBox, 150, 100, 15, 1,
		(PLHRES)&SysMgrPtrs[MSG_NUL], (PLHDATA)FieldName[2], 15, STYLE_WHCHAR|COMBO_NOEDIT,
		NULL, PARENT_FKEYS, (PLHMENU)&ComboRefList[2], NO_HELP},
		{ComboBox, 150, 120, 15, 1,
		(PLHRES)&SysMgrPtrs[MSG_NUL], (PLHDATA)FieldName[3], 15, STYLE_WHCHAR|COMBO_NOEDIT,
		NULL, PARENT_FKEYS, (PLHMENU)&ComboRefList[3], NO_HELP},
		{ComboBox, 150, 140, 15, 1,
		(PLHRES)&SysMgrPtrs[MSG_NUL], (PLHDATA)FieldName[4], 15, STYLE_WHCHAR|COMBO_NOEDIT,
		NULL, PARENT_FKEYS, (PLHMENU)&ComboRefList[4], NO_HELP},
		{ComboBox, 350, 60, 15, 1,
		(PLHRES)&SysMgrPtrs[MSG_NUL], (PLHDATA)FieldName[5], 15, STYLE_WHCHAR|COMBO_NOEDIT,
		NULL, PARENT_FKEYS, (PLHMENU)&ComboRefList[5], NO_HELP},
		{ComboBox, 350, 80, 15, 1,
		(PLHRES)&SysMgrPtrs[MSG_NUL], (PLHDATA)FieldName[6], 15, STYLE_WHCHAR|COMBO_NOEDIT,
		NULL, PARENT_FKEYS, (PLHMENU)&ComboRefList[6], NO_HELP},
		{ComboBox, 350, 100, 15, 1,
		(PLHRES)&SysMgrPtrs[MSG_NUL], (PLHDATA)FieldName[7], 15, STYLE_WHCHAR|COMBO_NOEDIT,
		NULL, PARENT_FKEYS, (PLHMENU)&ComboRefList[7], NO_HELP},
		{ComboBox, 350, 120, 15, 1,
		(PLHRES)&SysMgrPtrs[MSG_NUL], (PLHDATA)FieldName[8], 15, STYLE_WHCHAR|COMBO_NOEDIT,
		NULL, PARENT_FKEYS, (PLHMENU)&ComboRefList[8], NO_HELP},
		{ComboBox, 350, 140, 15, 1,
		(PLHRES)&SysMgrPtrs[MSG_NUL], (PLHDATA)FieldName[9], 15, STYLE_WHCHAR|COMBO_NOEDIT,
		NULL, PARENT_FKEYS, (PLHMENU)&ComboRefList[9], NO_HELP},
};

LHWINDOW FieldDlg = {
		(PLHCLASS)FieldHandler, 110, 20, 450, 160,
		(PLHRES)&SysMgrPtrs[MSG_FIELD], (PLHDATA)FieldArray, 
		countof(FieldArray), 0,	NULL, ChoseFkeys, NO_MENU, NO_HELP
};



int far ListBoxHandler(PLHWINDOW Window, WORD Message, WORD Data, WORD Extra,...) {
	switch (Message) {
		case KEYSTROKE:
		switch(Data) {
			case 0x0d: case 0x1b: case F10KEY:
				return SendMsg(Window, COMMAND, CMD_ESC, 0);
		}
	}
	return SubclassMsg(ListBox, Window, Message, Data, Extra);
}


void far DoField( void )
{
	int	i;
	for(i=0;i<10;i++){
		ComboRefList[i].Class=(PLHCLASS)ListBoxHandler;
		ComboRefList[i].x=0;
		ComboRefList[i].y=0;
		ComboRefList[i].w=15;
		ComboRefList[i].h=5;
		ComboRefList[i].Title=(PLHRES)&SysMgrPtrs[MSG_NUL];
		ComboRefList[i].Data=(PLHDATA)FieldListArray;
		ComboRefList[i].LogicalSize=MaxIndex+1;
		ComboRefList[i].Data=(PLHDATA)FieldListArray;
		ComboRefList[i].Style=STYLE_WHCHAR;
		ComboRefList[i].Parent=NULL;
		ComboRefList[i].Fkey=PARENT_FKEYS;
		ComboRefList[i].Menu=NO_MENU;
		ComboRefList[i].Help=NO_HELP;
	}
	SendMsg( &FieldDlg, CREATE, CREATE_FOCUS, 0 );
}


int far FieldHandler(PLHWINDOW Wnd, WORD Message, WORD Data, WORD Extra,...) {
	int	i,idx;
	int	tbl=0;
	switch (Message) {
		case KEYSTROKE:
			switch( Data ) {
		 		case ESC:
		 		case ENTER:
		 		case F10KEY:
					return SendMsg(Wnd, COMMAND, CMD_ESC, 0);
			}
			break;
		case CREATE:
			for(i=0;i<10;i++) FieldName[i][0]=NUL;
			break;
		case DESTROY:
			if(FlagAllField==0){
				for(i=0;i<100;i++) LstTbl[i]=-1;
				for(idx=0;idx<10;idx++)	{
					if(strlen(FieldName[idx])==0) continue;
					for(i=0;i<100;i++){
						if(strcmp(FieldData[i].name,FieldName[idx])==0){
							IdxTbl[tbl]=i;
							LstTbl[tbl++]=idx;
							break;
						}
					}
					if(i==100)	{IdxTbl[tbl]=-1; LstTbl[tbl++]=idx;}
				}
				for(tbl=9;tbl>0;tbl--){
					if(IdxTbl[tbl]>-1) break;
				}
				TotalTbl=++tbl;
			}
			else for(i=0;i<MaxIndex;i++) {
				if(i<10) strcpy(FieldName[i],FieldData[i].name);
				IdxTbl[tbl]=i;
				LstTbl[tbl++]=i;
				TotalTbl=MaxIndex;
			}
			break;
	}
	return SubclassMsg(DialogBox, Wnd, Message, Data, Extra);
}


LHWINDOW OptionArray[] = {
		{GroupBox, 120, 50, 15, 6,
		(PLHRES)&SysMgrPtrs[MSG_GROUPBOX_TYPE], NULL, NULL, STYLE_WHCHAR,
		CMD_DONE, PARENT_FKEYS, NO_MENU, NO_HELP},
		{RadioButton, 130, 70, 6, 1,
		(PLHRES)&SysMgrPtrs[MSG_BUTTON_GDB], (PLHDATA)&FlagType, 0,STYLE_WHCHAR,
		OptionArray, PARENT_FKEYS, NO_MENU, NO_HELP},
		{RadioButton, 130, 90, 6, 1,
		(PLHRES)&SysMgrPtrs[MSG_BUTTON_PDB], (PLHDATA)&FlagType, 1,STYLE_WHCHAR,
		OptionArray, PARENT_FKEYS, NO_MENU, NO_HELP},
/*		{RadioButton, 130, 110, 6, 1,
		(PLHRES)&SysMgrPtrs[MSG_BUTTON_NDB], (PLHDATA)&FlagType, 2,STYLE_WHCHAR,
		OptionArray, PARENT_FKEYS, NO_MENU, NO_HELP},
*/
		{GroupBox, 300, 50, 20, 6,
		(PLHRES)&SysMgrPtrs[MSG_GROUPBOX_CRLF], NULL, NULL, STYLE_WHCHAR,
		CMD_DONE, PARENT_FKEYS, NO_MENU, NO_HELP},
		{RadioButton, 310, 70, 6, 1,
		(PLHRES)&SysMgrPtrs[MSG_BUTTON_SPACE],(PLHDATA)&FlagCrlf,0,STYLE_WHCHAR,
		OptionArray+3, PARENT_FKEYS, NO_MENU, NO_HELP},
		{RadioButton, 310, 90, 6, 1,
		(PLHRES)&SysMgrPtrs[MSG_BUTTON_CHAR],(PLHDATA)&FlagCrlf,1,STYLE_WHCHAR,
		OptionArray+3, PARENT_FKEYS, NO_MENU, NO_HELP},
		{RadioButton, 310,110, 6, 1,
		(PLHRES)&SysMgrPtrs[MSG_BUTTON_STRT], (PLHDATA)&FlagCrlf,2,STYLE_WHCHAR,
		OptionArray+3, PARENT_FKEYS, NO_MENU, NO_HELP},
};

LHWINDOW OptionDlg = {
		(PLHCLASS)OptionHandler, 95, 20, 450, 140,
		(PLHRES)&SysMgrPtrs[MSG_OPTION], (PLHDATA)OptionArray, 
		countof(OptionArray), 0,NULL, ChoseFkeys, NO_MENU, NO_HELP
};

void far DoOption( void )
{
	SendMsg( &OptionDlg, CREATE, CREATE_FOCUS, 0 );
}

int far OptionHandler(PLHWINDOW Wnd, WORD Message, WORD Data, WORD Extra,...) {
	switch (Message) {
		case KEYSTROKE:
			switch(Data) {
				case ENTER: case ESC: case F10KEY:
					return SendMsg(Wnd, COMMAND, CMD_ESC, 0);
			}
			break;
	}
	return SubclassMsg(DialogBox, Wnd, Message, Data, Extra);
}






/*@DB2CSV@*/


void far DoD2C(void)
{
	DB2CSV_Record();
}

/*@CSV2DB@*/


void far DoC2D(void)
{
	CSV2DB_Record();
}



/* Quit */

void far DoQuit(void)
{
  Done = TRUE;
}


/* Other Functions */

int Init_DB(void)
{

	m_reg_far(&SysMgrPtrs,countof(SysMgrPtrs),4);
/*	map_resource_file("SAMPLE");	*/
	if(DB_Init()<0) m_thud();
	return 0;
}

void Read_Field(void)
{
	int i,j,k,len,idx,rec,ttlrec;
	unsigned char	toptype;
	unsigned char 	data[DATALEN];
	unsigned char	temp[80];

	FieldListArray[0] = ZeroField;
	if( DB_Open(&dblk,PathNameDb,FileType,NULL,Paswd,0,0) <0) {
		goto dbclose;
	}
	if( DB_CountRecords(&dblk,TYPE_DATA)==0) goto dbclose;
	for(rec=0,i=0,idx=1;rec<100;rec++){
		if(DB_ReadRecord(&dblk,TYPE_FIELDDEF,rec,data,DATALEN,&len)==0) {
			switch(data[0]){
				case 0:
				case 1:
				case 2:
				case 3:
				case 4:
				case 5:
				case 6:
				case 7:
				case 8:
				case 9:
				case 10:
				case 13:
					FieldData[i].index=rec;
					FieldData[i].ptr=*(int *)(data+2);
					FieldData[i].type=data[0];
					if(DataTop<FieldData[i].ptr) {
						DataTop=FieldData[i].ptr;
						toptype=FieldData[i].type;
					}
					strcpy(temp,data+7);
					for(j=0,k=0;k<100;k++){
						if(temp[k]!='&') FieldData[i].name[j++]=temp[k];
						if(temp[k]==NUL) break;
					}
					FieldListArray[idx] = FieldData[i].name;
					i++; idx++;
					break;
				default:
					if(DataTop < *(int *)(data+2)) {
						DataTop=*(int *)(data+2);
						toptype=data[0];
					}
					break;
			}
		}
	}
	MaxIndex=i;
	switch(toptype){
		case 0:		DataTop=DataTop+2;
					break;
		case 8:		DataTop=DataTop+4;
					break;
		default:	DataTop=DataTop+3;
	}
	ttlrec=DB_CountRecords(&dblk,TYPE_NOTE);
	for(rec=0;rec<ttlrec;rec++)
		if(DB_ReadRecord(&dblk,TYPE_NOTE,rec,data,DATALEN,&len)==0){
			MaxNote=rec;
			data[DATALEN-1]=NUL;
		}
dbclose:
	DB_Close(&dblk);
}


void DB2CSV_Record(void)
{
	int i,j,idx,rec,tbl,len,lst;
	char	temp[128];
	unsigned char	data[DATALEN];
	unsigned char	datafix[DATALEN];
	FILE	fp;

	if( DB_Open(&dblk,PathNameDb,FileType,NULL,Paswd,0,0) <0){
		DrawText( 250, 20, "DB File no opened.", DRAW_NORMAL,FONT_NORMAL);
		goto dbclose;
	}
	if( DB_CountRecords(&dblk,TYPE_DATA)==0) goto dbclose;
	if( DB_SetCurrentViewpt(&dblk,0) <0) goto dbclose;
	TotalRec=dblk.viewptcount;
	if( m_open( &fp,PathNameCsv,strlen(PathNameCsv),0,0 ) == 0 )
		m_seek( &fp,2,0L);
	else if(m_create(&fp,PathNameCsv,strlen(PathNameCsv),0,0 )!=0){
		DrawText( 250, 20, "CSV File not opened.            ", DRAW_NORMAL,FONT_NORMAL);
		goto dbclose;
	}
	strcpy(datafix,"");
	for(tbl=0;tbl<TotalTbl;tbl++){
		idx=IdxTbl[tbl];
		if(idx==-1) strcpy(RecordDataFix,"\"\"");
		else DB2CSV_Conv(RecordDataFix,FieldData[idx].name,0x02);
		if(tbl!=0) strcat(datafix,",");
		strcat(datafix,RecordDataFix);
	}
	strcat(datafix,Crlf);
	m_write( &fp,datafix,strlen(datafix));
	for(rec=0;rec<TotalRec;rec++) {
		sprintf(temp,"Database -> CSV Writing...(%d/%d)          ",rec,TotalRec);
		DrawText( 250, 20, temp, DRAW_NORMAL,FONT_NORMAL);
/*		ClearRecord(data,DATALEN);
		ClearRecord(datafix,DATALEN);*/
		data[0]=NUL;
		datafix[0]=NUL;
		if ( DB_ReadRecord(&dblk,TYPE_DATA,(*dblk.viewpt)[rec],data,
			DATALEN,&len) <0) {
				sprintf(temp,"Read Error.                 ",rec,TotalRec);
				DrawText( 250, 20, temp, DRAW_NORMAL,FONT_NORMAL);
				goto dbclose;
		}
		for(tbl=0;tbl<TotalTbl;tbl++){
/*			ClearRecord(RecordData,RECLEN);
			ClearRecord(RecordDataFix,RECLEN);*/
			RecordData[0]=NUL;
			RecordDataFix[0]=NUL;
			idx=IdxTbl[tbl];
			if(idx==-1) strcpy(RecordDataFix,"\"\"");
			else {
				DB_GetField(&dblk,data,FieldData[idx].index,RecordData,RECLEN);
				RecordData[RECLEN-10]=NUL;
				DB2CSV_Conv(RecordDataFix,RecordData,FieldData[idx].type);
			}

			if(tbl!=0) strcat(datafix,",");
			strcat(datafix,RecordDataFix);
			lst=LstTbl[tbl];
			if(lst!=-1) {
				sprintf(temp,"%s                    ",RecordDataFix);
				temp[20]=NUL;
				if(lst<5) 	DrawText( 110, 50+lst*20, temp, DRAW_NORMAL,FONT_NORMAL);
				else if(lst<10) DrawText( 405, lst*20-50, temp, DRAW_NORMAL,FONT_NORMAL);
			}
		}
		strcat(datafix,Crlf);
		m_write( &fp,datafix,strlen(datafix));
	}
	sprintf(temp,"Database -> CSV Completed (%d/%d)         ",rec,TotalRec);
	DrawText( 250, 20, temp, DRAW_NORMAL,FONT_NORMAL);
	dbclose:
		DB_Close(&dblk);
		m_close(&fp);
}

void	DB2CSV_Conv(unsigned char *datafix, unsigned char *data, unsigned char type)
{
	int	i,j;
	switch(type){
		case 0:
			if(data[1]==0x01) strcpy(datafix,"1");
			else strcpy(datafix,"0");
			break;
		case 1:
		case 9:
			if((data[0]==0xff) && (data[1]==0x01)) strcpy(datafix,"1");
			else strcpy(datafix,"0");
			break;
		case 2:
		case 3:
		case 5:
		case 6:
		case 7:
		case 8:
			strcpy(datafix,"\"");
			strcat(datafix,data);
			strcat(datafix,"\"");
			break;
		case 4:
			strcpy(datafix,data);
			if (strlen(datafix)==0) strcpy(datafix,"0");
			break;
		case 10:
			datafix[0]='\"';
			for(i=0,j=1;i<RECLEN;i++){
				switch(FlagCrlf){
					case 0:
						if(data[i]==CR) continue;
						if(data[i]==LF) {
							datafix[j++]=' ';
							continue;
						}
						break;
					case 1:
						if(data[i]==CR) continue;
						if(data[i]==LF) {
							datafix[j++]='$';
							datafix[j++]='!';
							continue;
						}
						break;
					case 2:
						break;
				}
				datafix[j++]=data[i];
				if(data[i]==NUL) {strcat(datafix,"\""); break;}
			}
			datafix[RECLEN-1]=NUL;
			break;
	}
}


void CSV2DB_Record(void)
{
	int i,j,k,idx,rec,len,tbl,lst;
	int	flageod=0;
	int	flagslct[100];
	char	temp[128];
	unsigned char	data[DATALEN];
	unsigned char	datafix[DATALEN];
	FILE	fp;

	if( DB_Open(&dblk,PathNameDb,FileType,NULL,Paswd,0,0) <0){
		DrawText( 250, 20, "DB File not opened.", DRAW_NORMAL,FONT_NORMAL);
		goto dbclose;
	}
	if( DB_SetCurrentViewpt(&dblk,0) <0) goto dbclose;
	for(i=0;i<MaxIndex;i++)	flagslct[i]=0;
	for(tbl=0;tbl<TotalTbl;tbl++) if(IdxTbl[tbl]!=-1) flagslct[IdxTbl[tbl]]=1;
	if( m_open( &fp,PathNameCsv,strlen(PathNameCsv),0,0 ) != 0 ){
		DrawText( 250, 20, "CSV File not opened.", DRAW_NORMAL,FONT_NORMAL);
		goto dbclose;
	}
	for(rec=0;rec<TOTALREC;rec++){
		sprintf(temp,"CSV -> Database Writing...(%d line)          ",rec);
		DrawText( 250, 20, temp, DRAW_NORMAL,FONT_NORMAL);
/*		ClearRecord(data,DATALEN);
		ClearRecord(datafix,DATALEN);*/
		data[0]=NUL;
		datafix[0]=NUL;
		if(m_readline(&fp,data)!=0) break;
		j=0;k=DataTop;flageod=0;datafix[k-1]=NUL;
		for(tbl=0;tbl<TotalTbl;tbl++){
/*			ClearRecord(RecordData,RECLEN);
			ClearRecord(RecordDataFix,RECLEN);*/
			RecordData[0]=NUL;
			RecordDataFix[0]=NUL;
			idx=IdxTbl[tbl];
			if(flageod==1) {
				if(idx!=-1){
					RecordData[0]=NUL;
					*(int *)(datafix+FieldData[idx].ptr) = DataTop-1;
				}
				continue;
			}
			m_readrec(data, &j, &flageod);
			if(idx==-1) continue;
			if(flagslct[tbl]==0) continue;
			switch(FieldData[idx].type){
				case 2:
				case 3:
				case 6:
				case 13:
					if(RecordData[0]==NUL) *(int *)(datafix+FieldData[idx].ptr) = DataTop-1;
					else {
						*(int *)(datafix+FieldData[idx].ptr)=k;
						strcpy(datafix+k,RecordData);
						k=k+strlen(RecordData)+1;
					}
					break;
				case 4:
					if(strcmp(RecordData,"0")==0){
						*(int *)(datafix+FieldData[idx].ptr) = DataTop-1;
						RecordData[0]=NUL;
					}
					else if(numcheck(RecordData)!=0){
						*(int *)(datafix+FieldData[idx].ptr) = DataTop-1;
						RecordData[0]=NUL;
					}
					else if(RecordData[0]==NUL) 
						*(int *)(datafix+FieldData[idx].ptr) = DataTop-1;
					else {
						*(int *)(datafix+FieldData[idx].ptr)=k;
						strcpy(datafix+k,RecordData);
						k=k+strlen(RecordData)+1;
					}
					break;
				case 0:
					if(RecordData[0]=='1')
							*(datafix+FieldData[idx].ptr)=0x01;
					else	*(datafix+FieldData[idx].ptr)=0x00;
					break;
				case 1:
				case 9:
					if(RecordData[0]=='1')
							*(int *)(datafix+FieldData[idx].ptr)=1;
					else	*(int *)(datafix+FieldData[idx].ptr)=0;
					break;
				case 10:
					if(RecordData[0]==NUL) 
						*(int *)(datafix+FieldData[idx].ptr)=-1;
					else{
						*(int *)(datafix+FieldData[idx].ptr)=++MaxNote;
						CSV2DB_Conv(RecordDataFix,RecordData,10);
						DB_WriteRecord(&dblk,TYPE_NOTE,MaxNote,RecordDataFix,strlen(RecordDataFix),0);
					}
					break;
			}
			lst=LstTbl[tbl];
			if(lst!=-1) {
				if(FieldData[idx].type==10)
					sprintf(temp,"%s                    ",RecordDataFix);
				else
					sprintf(temp,"%s                    ",RecordData);
				temp[20]=NUL;
				if(lst<5) 	DrawText( 110, 50+lst*20, temp, DRAW_NORMAL,FONT_NORMAL);
				else if(lst<10) DrawText( 405, lst*20-50, temp, DRAW_NORMAL,FONT_NORMAL);
			}
		}
		for(i=0;i<MaxIndex;i++){
			if(flagslct[i]==0){
				switch(FieldData[i].type){
					case 2:
					case 3:
					case 4:
					case 6:
					case 13:
						*(int *)(datafix+FieldData[i].ptr) = DataTop-1;
						break;
					case 0:
						*(datafix+FieldData[i].ptr)=0x00;
						break;
					case 1:
					case 9:
						*(int *)(datafix+FieldData[i].ptr)=0;
						break;
					case 10:
						*(int *)(datafix+FieldData[i].ptr)=-1;
						break;
				}
			}
		}
		DB_AddRecord(&dblk,TYPE_DATA,datafix,k,0);
	}
	sprintf(temp,"CSV -> Database Completed (%d line)          ",rec);
	DrawText( 250, 20, temp, DRAW_NORMAL,FONT_NORMAL);
	
	dbclose:
		DB_Close(&dblk);
		m_close(&fp);
}

void	CSV2DB_Conv(unsigned char *datafix, unsigned char *data, unsigned char type){

	int	i,j;
	if(type==10){
		for(i=0,j=0;i<RECLEN;i++){
			if((data[i]=='$') && (data[i+1]=='!')) {
				datafix[j++]=CR;
				datafix[j++]=LF;
				i++;
			}
			else datafix[j++]=data[i];
			if(data[i]==NUL) break;
		}
	}
}


int	m_readline(FILE *fp, unsigned char *data){
	int	i=0;
	int	len;
	data[0]=NUL;
	for(i=0;i<DATALEN;i++){
		m_read( fp,data+i,1,&len);
		if(len==0){
			if(i==0) return 1;
			else {data[i]=NUL;	break;}
		}
		if(data[i]==LF) {
			data[i+1]=NUL; break;}
	}
	return 0;
}

void m_readrec(char *data, int *offset, int *flageod){
	int	flagquote=0;
	int	i=0;
	int	j=*offset;
	if(data[j]=='\"')  flagquote=1;
	else if(data[j]==CR) {
		RecordData[0]=NUL;	j=j+2; *flageod=1;	*offset=j;	return;}
	else if(data[j]==',') {
		RecordData[0]=NUL;	j++;   *offset=j;	return;}
	else {RecordData[i++]=data[j]; flagquote=0;}
	j++;
	for(;j<RECLEN;j++){
		if(data[j]==CR) {
			RecordData[i++]=NUL;	j=j+2; *flageod=1;	break;}
		else if((data[j]==',') && (flagquote==0)) {
			RecordData[i++]=NUL;	j++;   break;}
		else if(data[j]=='\"') {
			RecordData[i++]=NUL; 
			if(i==1) RecordData[0]=NUL; j=j+2; break;}
		else RecordData[i++]=data[j];
	}
	*offset=j;
	return;
}

int		numcheck(char *data){
	int	i,len;
	len=strlen(data);
	for(i=0;i<len;i++){
		switch(data[i]){
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ' ':
			case '.':
			case '+':
			case '-':
			case ',':
			case '\\':
			case '$':
				break;
			default:
				return -1;
		}
	}
	return 0;
}

/*
void	ClearRecord (unsigned char *data, int len){
	int	i;
	for(i=0;i<len;i++) data[i]=NUL;
}

*/
void Dispatch( void )
{
	Done = FALSE;
	while(!Done) {
		app_event.norm.do_event = DO_EVENT;
		m_action( &app_event );
		switch( app_event.norm.kind ) {
			case E_ACTIV:
			case E_REFRESH:
				DB_Reactivate(&dblk);
				ReactivateLHAPI( &CapData );
				break;
			case E_DEACT:
				DB_Deactivate(&dblk);
				DeactivateLHAPI();
				break;
			case E_TERM:
			case E_BREAK:
				DeactivateLHAPI();
				Done = TRUE;
				break;
			case E_NONE:
				SendMsg(&TDateTime, DRAW, DRAW_ALL, 0);
				break;
			case E_KEY:
				SendFocusMsg(KEYSTROKE, app_event.norm.data, app_event.norm.scan);
				break;
		}
	}
}

void main( void )
{
    InitRscMsgPtr(); 
	m_init_app( SYSTEM_MANAGER_VERSION );
	InitializeLHAPI( &CapData );
	SetDefaultFont(FONT_NORMAL);
	m_reg_app_name(SysMgrPtrs[MSG_APP_NAME]);
	SendMsg( &MainView, CREATE, CREATE_FOCUS, 0 );
	SendMsg( &MainTitle, CREATE, CREATE_NORMAL, 0 );
	Init_DB();
	Dispatch();
	m_fini();
}

